# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: D

def enigmatic_whisper(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history) + 1
    opp_coop_rate = opp_history.count("C") / len(opp_history)
    
    # Early phase: build trust
    if current_round <= 3:
        return "C"
    
    # Mid-game: adaptive response
    elif 4 <= current_round <= 7:
        if opp_coop_rate >= 0.7:
            if random.random() < 0.1:
                return "D"
            return "C"
        else:
            return "D"
    
    # Late-game: exploit or reciprocate
    else:
        if current_round == 10:
            return "D"
        if opp_coop_rate >= 0.6:
            return "C"
        else:
            return "D"